/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.AbstractLinearClassifierFactory;
import edu.stanford.nlp.classify.LinearClassifier;
import edu.stanford.nlp.classify.LinearClassifierFactory;
import edu.stanford.nlp.ling.BasicDatum;
import edu.stanford.nlp.ling.Datum;
import java.util.ArrayList;

public class ClassifierExample {
    protected static final String GREEN = "green";
    protected static final String RED = "red";
    protected static final String WORKING = "working";
    protected static final String BROKEN = "broken";

    private ClassifierExample() {
    }

    protected static Datum<String, String> makeStopLights(String ns, String ew) {
        ArrayList<String> features = new ArrayList<String>();
        features.add("NS=" + ns);
        features.add("EW=" + ew);
        String label = ns.equals(ew) ? BROKEN : WORKING;
        return new BasicDatum<String, String>(features, label);
    }

    public static void main(String[] args) {
        ArrayList trainingData = new ArrayList();
        trainingData.add(ClassifierExample.makeStopLights(GREEN, RED));
        trainingData.add(ClassifierExample.makeStopLights(GREEN, RED));
        trainingData.add(ClassifierExample.makeStopLights(GREEN, RED));
        trainingData.add(ClassifierExample.makeStopLights(RED, GREEN));
        trainingData.add(ClassifierExample.makeStopLights(RED, GREEN));
        trainingData.add(ClassifierExample.makeStopLights(RED, GREEN));
        trainingData.add(ClassifierExample.makeStopLights(RED, RED));
        Datum<String, String> workingLights = ClassifierExample.makeStopLights(GREEN, RED);
        Datum<String, String> brokenLights = ClassifierExample.makeStopLights(RED, RED);
        LinearClassifierFactory factory = new LinearClassifierFactory();
        factory.useConjugateGradientAscent();
        factory.setVerbose(true);
        factory.setSigma(10.0);
        LinearClassifier<String, String> classifier = ((AbstractLinearClassifierFactory)factory).trainClassifier(trainingData);
        classifier.dump();
        System.out.println("Working instance got: " + classifier.classOf(workingLights));
        classifier.justificationOf(workingLights);
        System.out.println("Broken instance got: " + classifier.classOf(brokenLights));
        classifier.justificationOf(brokenLights);
    }
}

