/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.AuxiliaryTree;
import edu.stanford.nlp.trees.tregex.tsurgeon.CoindexationGenerator;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import java.util.Map;

class AdjoinNode
extends TsurgeonPattern {
    private final AuxiliaryTree adjunctionTree;

    public AdjoinNode(AuxiliaryTree t, TsurgeonPattern p) {
        this("adjoin", t, p);
    }

    public AdjoinNode(String name, AuxiliaryTree t, TsurgeonPattern p) {
        super(name, new TsurgeonPattern[]{p});
        if (t == null || p == null) {
            throw new NullPointerException("AdjoinNode: illegal null argument, t=" + t + ", p=" + p);
        }
        this.adjunctionTree = t;
    }

    protected AuxiliaryTree adjunctionTree() {
        return this.adjunctionTree;
    }

    @Override
    public TsurgeonMatcher matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
        return new Matcher(newNodeNames, coindexer);
    }

    @Override
    public String toString() {
        return super.toString() + "<-" + this.adjunctionTree.toString();
    }

    private class Matcher
    extends TsurgeonMatcher {
        public Matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
            super(AdjoinNode.this, newNodeNames, coindexer);
        }

        @Override
        public Tree evaluate(Tree tree, TregexMatcher tregex) {
            Tree targetNode = this.childMatcher[0].evaluate(tree, tregex);
            Tree parent = targetNode.parent(tree);
            AuxiliaryTree ft = AdjoinNode.this.adjunctionTree.copy(this);
            ft.foot.setChildren(targetNode.getChildrenAsList());
            if (parent == null) {
                return ft.tree;
            }
            int i = parent.objectIndexOf(targetNode);
            parent.setChild(i, ft.tree);
            return tree;
        }
    }
}

