/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.AuxiliaryTree;
import edu.stanford.nlp.trees.tregex.tsurgeon.HoldTreeNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonRuntimeException;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.Function;
import java.util.List;

class ReplaceNode
extends TsurgeonPattern {
    private static final Function<AuxiliaryTree, HoldTreeNode> convertAuxiliaryToHold = new Function<AuxiliaryTree, HoldTreeNode>(){

        @Override
        public HoldTreeNode apply(AuxiliaryTree t) {
            return new HoldTreeNode(t);
        }
    };

    public ReplaceNode(TsurgeonPattern oldNode, TsurgeonPattern ... newNodes) {
        super("replace", ArrayUtils.concatenate(new TsurgeonPattern[]{oldNode}, newNodes));
    }

    public ReplaceNode(TsurgeonPattern oldNode, List<AuxiliaryTree> trees) {
        this(oldNode, CollectionUtils.transformAsList(trees, convertAuxiliaryToHold).toArray(new TsurgeonPattern[trees.size()]));
    }

    @Override
    public Tree evaluate(Tree t, TregexMatcher m) {
        Tree oldNode = this.children[0].evaluate(t, m);
        if (oldNode == t) {
            if (this.children.length > 2) {
                throw new TsurgeonRuntimeException("Attempted to replace a root node with more than one node, unable to proceed");
            }
            return this.children[1].evaluate(t, m);
        }
        Tree parent = oldNode.parent(t);
        int i = parent.objectIndexOf(oldNode);
        parent.removeChild(i);
        for (int j = 1; j < this.children.length; ++j) {
            Tree newNode = this.children[j].evaluate(t, m);
            parent.insertDtr(newNode.deepCopy(), i + j - 1);
        }
        return t;
    }
}

