/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.Dataset;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.util.Index;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class WeightedDataset<L, F>
extends Dataset<L, F> {
    private static final long serialVersionUID = -5435125789127705430L;
    protected float[] weights;

    public WeightedDataset(Index<L> labelIndex, int[] labels, Index<F> featureIndex, int[][] data, int size, float[] weights) {
        super(labelIndex, labels, featureIndex, data, size);
        this.weights = weights;
    }

    public WeightedDataset() {
        this(10);
    }

    public WeightedDataset(int initSize) {
        super(initSize);
        this.weights = new float[initSize];
    }

    private float[] trimToSize(float[] i) {
        float[] newI = new float[this.size];
        System.arraycopy(i, 0, newI, 0, this.size);
        return newI;
    }

    public float[] getWeights() {
        this.weights = this.trimToSize(this.weights);
        return this.weights;
    }

    @Override
    public float[] getFeatureCounts() {
        float[] counts = new float[this.featureIndex.size()];
        int m = this.size;
        for (int i = 0; i < m; ++i) {
            int n = this.data[i].length;
            for (int j = 0; j < n; ++j) {
                int n2 = this.data[i][j];
                counts[n2] = counts[n2] + this.weights[i];
            }
        }
        return counts;
    }

    @Override
    public void add(Datum<L, F> d) {
        this.add(d, 1.0f);
    }

    @Override
    public void add(Collection<F> features, L label) {
        this.add(features, label, 1.0f);
    }

    public void add(Datum<L, F> d, float weight) {
        this.add(d.asFeatures(), d.label(), weight);
    }

    @Override
    protected void ensureSize() {
        super.ensureSize();
        if (this.weights.length == this.size) {
            float[] newWeights = new float[this.size * 2];
            System.arraycopy(this.weights, 0, newWeights, 0, this.size);
            this.weights = newWeights;
        }
    }

    public void add(Collection<F> features, L label, float weight) {
        this.ensureSize();
        this.addLabel(label);
        this.addFeatures(features);
        this.weights[this.size++] = weight;
    }

    @Override
    public void randomize(long randomSeed) {
        Random rand = new Random(randomSeed);
        for (int j = this.size - 1; j > 0; --j) {
            int randIndex = rand.nextInt(j);
            int[] tmp = this.data[randIndex];
            this.data[randIndex] = this.data[j];
            this.data[j] = tmp;
            int tmpL = this.labels[randIndex];
            this.labels[randIndex] = this.labels[j];
            this.labels[j] = tmpL;
            float tmpW = this.weights[randIndex];
            this.weights[randIndex] = this.weights[j];
            this.weights[j] = tmpW;
        }
    }

    @Override
    public <E> void shuffleWithSideInformation(long randomSeed, List<E> sideInformation) {
        if (this.size != sideInformation.size()) {
            throw new IllegalArgumentException("shuffleWithSideInformation: sideInformation not of same size as Dataset");
        }
        Random rand = new Random(randomSeed);
        for (int j = this.size - 1; j > 0; --j) {
            int randIndex = rand.nextInt(j);
            int[] tmp = this.data[randIndex];
            this.data[randIndex] = this.data[j];
            this.data[j] = tmp;
            int tmpL = this.labels[randIndex];
            this.labels[randIndex] = this.labels[j];
            this.labels[j] = tmpL;
            float tmpW = this.weights[randIndex];
            this.weights[randIndex] = this.weights[j];
            this.weights[j] = tmpW;
            E tmpE = sideInformation.get(randIndex);
            sideInformation.set(randIndex, sideInformation.get(j));
            sideInformation.set(j, tmpE);
        }
    }
}

