/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.classify.LinearClassifier;
import edu.stanford.nlp.classify.LinearClassifierFactory;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;

public class RVFDataset<L, F>
extends GeneralDataset<L, F> {
    private static final long serialVersionUID = -3841757837680266182L;
    private double[][] values;
    private double[] minValues;
    private double[] maxValues;
    double[] means;
    double[] stdevs;
    private ArrayList<Pair<String, String>> sourcesAndIds;

    public RVFDataset() {
        this(10);
    }

    public RVFDataset(int numDatums, Index<F> featureIndex, Index<L> labelIndex) {
        this(numDatums);
        this.labelIndex = labelIndex;
        this.featureIndex = featureIndex;
    }

    public RVFDataset(Index<F> featureIndex, Index<L> labelIndex) {
        this(10);
        this.labelIndex = labelIndex;
        this.featureIndex = featureIndex;
    }

    public RVFDataset(int numDatums) {
        this.initialize(numDatums);
    }

    public RVFDataset(Index<L> labelIndex, int[] labels, Index<F> featureIndex, int[][] data, double[][] values) {
        this.labelIndex = labelIndex;
        this.labels = labels;
        this.featureIndex = featureIndex;
        this.data = data;
        this.values = values;
        this.size = labels.length;
    }

    @Override
    public Pair<GeneralDataset<L, F>, GeneralDataset<L, F>> split(double percentDev) {
        int devSize = (int)(percentDev * (double)this.size());
        int trainSize = this.size() - devSize;
        int[][] devData = new int[devSize][];
        double[][] devValues = new double[devSize][];
        int[] devLabels = new int[devSize];
        int[][] trainData = new int[trainSize][];
        double[][] trainValues = new double[trainSize][];
        int[] trainLabels = new int[trainSize];
        System.arraycopy(this.data, 0, devData, 0, devSize);
        System.arraycopy(this.values, 0, devValues, 0, devSize);
        System.arraycopy(this.labels, 0, devLabels, 0, devSize);
        System.arraycopy(this.data, devSize, trainData, 0, trainSize);
        System.arraycopy(this.values, devSize, trainValues, 0, trainSize);
        System.arraycopy(this.labels, devSize, trainLabels, 0, trainSize);
        RVFDataset<L, F> dev = new RVFDataset<L, F>(this.labelIndex, devLabels, this.featureIndex, devData, devValues);
        RVFDataset<L, F> train = new RVFDataset<L, F>(this.labelIndex, trainLabels, this.featureIndex, trainData, trainValues);
        return new Pair<GeneralDataset<L, F>, GeneralDataset<L, F>>(train, dev);
    }

    public void scaleFeaturesGaussian() {
        int j;
        int i;
        this.means = new double[this.numFeatures()];
        Arrays.fill(this.means, 0.0);
        for (int i2 = 0; i2 < this.size(); ++i2) {
            for (int j2 = 0; j2 < this.data[i2].length; ++j2) {
                int n = this.data[i2][j2];
                this.means[n] = this.means[n] + this.values[i2][j2];
            }
        }
        ArrayMath.multiplyInPlace(this.means, 1.0 / (double)this.size());
        this.stdevs = new double[this.numFeatures()];
        Arrays.fill(this.stdevs, 0.0);
        double[] deltaX = new double[this.numFeatures()];
        for (i = 0; i < this.size(); ++i) {
            int f;
            for (f = 0; f < this.numFeatures(); ++f) {
                deltaX[f] = -this.means[f];
            }
            for (j = 0; j < this.data[i].length; ++j) {
                int n = this.data[i][j];
                deltaX[n] = deltaX[n] + this.values[i][j];
            }
            for (f = 0; f < this.numFeatures(); ++f) {
                int n = f;
                this.stdevs[n] = this.stdevs[n] + deltaX[f] * deltaX[f];
            }
        }
        for (int f = 0; f < this.numFeatures(); ++f) {
            int n = f;
            this.stdevs[n] = this.stdevs[n] / (double)(this.size() - 1);
            this.stdevs[f] = Math.sqrt(this.stdevs[f]);
        }
        for (i = 0; i < this.size(); ++i) {
            for (j = 0; j < this.data[i].length; ++j) {
                int fID = this.data[i][j];
                if (this.stdevs[fID] == 0.0) continue;
                this.values[i][j] = (this.values[i][j] - this.means[fID]) / this.stdevs[fID];
            }
        }
    }

    public void scaleFeatures() {
        int f;
        int j;
        int i;
        this.minValues = new double[this.featureIndex.size()];
        this.maxValues = new double[this.featureIndex.size()];
        Arrays.fill(this.minValues, Double.POSITIVE_INFINITY);
        Arrays.fill(this.maxValues, Double.NEGATIVE_INFINITY);
        for (i = 0; i < this.size(); ++i) {
            for (j = 0; j < this.data[i].length; ++j) {
                f = this.data[i][j];
                if (this.values[i][j] < this.minValues[f]) {
                    this.minValues[f] = this.values[i][j];
                }
                if (!(this.values[i][j] > this.maxValues[f])) continue;
                this.maxValues[f] = this.values[i][j];
            }
        }
        for (int f2 = 0; f2 < this.featureIndex.size(); ++f2) {
            if (this.minValues[f2] == Double.POSITIVE_INFINITY) {
                throw new RuntimeException("minValue for feature " + f2 + " not assigned. ");
            }
            if (this.maxValues[f2] != Double.NEGATIVE_INFINITY) continue;
            throw new RuntimeException("maxValue for feature " + f2 + " not assigned.");
        }
        for (i = 0; i < this.size(); ++i) {
            for (j = 0; j < this.data[i].length; ++j) {
                f = this.data[i][j];
                if (this.minValues[f] == this.maxValues[f]) continue;
                this.values[i][j] = (this.values[i][j] - this.minValues[f]) / (this.maxValues[f] - this.minValues[f]);
            }
        }
    }

    public void ensureRealValues() {
        double[][] values = this.getValuesArray();
        int[][] data = this.getDataArray();
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < values[i].length; ++j) {
                if (Double.isNaN(values[i][j])) {
                    int fID = data[i][j];
                    Object feature = this.featureIndex.get(fID);
                    throw new RuntimeException("datum " + i + " has a NaN value for feature:" + feature);
                }
                if (!Double.isInfinite(values[i][j])) continue;
                int fID = data[i][j];
                Object feature = this.featureIndex.get(fID);
                throw new RuntimeException("datum " + i + " has infinite value for feature:" + feature);
            }
        }
    }

    public RVFDataset<L, F> scaleDataset(RVFDataset<L, F> dataset) {
        RVFDataset<L, F> newDataset = new RVFDataset<L, F>(this.featureIndex, this.labelIndex);
        for (int i = 0; i < dataset.size(); ++i) {
            Datum datum = dataset.getDatum(i);
            newDataset.add(this.scaleDatum((RVFDatum<L, F>)datum));
        }
        return newDataset;
    }

    public RVFDatum<L, F> scaleDatum(RVFDatum<L, F> datum) {
        if (this.minValues == null || this.maxValues == null) {
            this.scaleFeatures();
        }
        ClassicCounter<F> scaledFeatures = new ClassicCounter<F>();
        for (F feature : datum.asFeatures()) {
            int fID = this.featureIndex.indexOf(feature);
            if (fID < 0) continue;
            double oldVal = datum.asFeaturesCounter().getCount(feature);
            double newVal = this.minValues[fID] != this.maxValues[fID] ? (oldVal - this.minValues[fID]) / (this.maxValues[fID] - this.minValues[fID]) : oldVal;
            scaledFeatures.incrementCount(feature, newVal);
        }
        return new RVFDatum(scaledFeatures, datum.label());
    }

    public RVFDataset<L, F> scaleDatasetGaussian(RVFDataset<L, F> dataset) {
        RVFDataset<L, F> newDataset = new RVFDataset<L, F>(this.featureIndex, this.labelIndex);
        for (int i = 0; i < dataset.size(); ++i) {
            Datum datum = dataset.getDatum(i);
            newDataset.add(this.scaleDatumGaussian((RVFDatum<L, F>)datum));
        }
        return newDataset;
    }

    public RVFDatum<L, F> scaleDatumGaussian(RVFDatum<L, F> datum) {
        if (this.means == null || this.stdevs == null) {
            this.scaleFeaturesGaussian();
        }
        ClassicCounter<F> scaledFeatures = new ClassicCounter<F>();
        for (F feature : datum.asFeatures()) {
            int fID = this.featureIndex.indexOf(feature);
            if (fID < 0) continue;
            double oldVal = datum.asFeaturesCounter().getCount(feature);
            double newVal = this.stdevs[fID] != 0.0 ? (oldVal - this.means[fID]) / this.stdevs[fID] : oldVal;
            scaledFeatures.incrementCount(feature, newVal);
        }
        return new RVFDatum(scaledFeatures, datum.label());
    }

    @Override
    public Pair<GeneralDataset<L, F>, GeneralDataset<L, F>> split(int start, int end) {
        int devSize = end - start;
        int trainSize = this.size() - devSize;
        int[][] devData = new int[devSize][];
        double[][] devValues = new double[devSize][];
        int[] devLabels = new int[devSize];
        int[][] trainData = new int[trainSize][];
        double[][] trainValues = new double[trainSize][];
        int[] trainLabels = new int[trainSize];
        System.arraycopy(this.data, start, devData, 0, devSize);
        System.arraycopy(this.values, start, devValues, 0, devSize);
        System.arraycopy(this.labels, start, devLabels, 0, devSize);
        System.arraycopy(this.data, 0, trainData, 0, start);
        System.arraycopy(this.data, end, trainData, start, this.size() - end);
        System.arraycopy(this.values, 0, trainValues, 0, start);
        System.arraycopy(this.values, end, trainValues, start, this.size() - end);
        System.arraycopy(this.labels, 0, trainLabels, 0, start);
        System.arraycopy(this.labels, end, trainLabels, start, this.size() - end);
        RVFDataset<L, F> dev = new RVFDataset<L, F>(this.labelIndex, devLabels, this.featureIndex, devData, devValues);
        RVFDataset<L, F> train = new RVFDataset<L, F>(this.labelIndex, trainLabels, this.featureIndex, trainData, trainValues);
        return new Pair<GeneralDataset<L, F>, GeneralDataset<L, F>>(train, dev);
    }

    @Override
    public void add(Datum<L, F> d) {
        if (d instanceof RVFDatum) {
            this.addLabel(d.label());
            this.addFeatures(((RVFDatum)d).asFeaturesCounter());
            ++this.size;
        } else {
            this.addLabel(d.label());
            this.addFeatures(Counters.asCounter(d.asFeatures()));
            ++this.size;
        }
    }

    public void add(Datum<L, F> d, String src, String id) {
        if (d instanceof RVFDatum) {
            this.addLabel(d.label());
            this.addFeatures(((RVFDatum)d).asFeaturesCounter());
            this.addSourceAndId(src, id);
            ++this.size;
        } else {
            this.addLabel(d.label());
            this.addFeatures(Counters.asCounter(d.asFeatures()));
            this.addSourceAndId(src, id);
            ++this.size;
        }
    }

    @Override
    public RVFDatum<L, F> getDatum(int index) {
        return this.getRVFDatum(index);
    }

    @Override
    public RVFDatum<L, F> getRVFDatum(int index) {
        ClassicCounter c = new ClassicCounter();
        for (int i = 0; i < this.data[index].length; ++i) {
            c.incrementCount(this.featureIndex.get(this.data[index][i]), this.values[index][i]);
        }
        return new RVFDatum(c, this.labelIndex.get(this.labels[index]));
    }

    public String getRVFDatumSource(int index) {
        return this.sourcesAndIds.get(index).first();
    }

    public String getRVFDatumId(int index) {
        return this.sourcesAndIds.get(index).second();
    }

    private void addSourceAndId(String src, String id) {
        this.sourcesAndIds.add(new Pair<String, String>(src, id));
    }

    private void addLabel(L label) {
        if (this.labels.length == this.size) {
            int[] newLabels = new int[this.size * 2];
            System.arraycopy(this.labels, 0, newLabels, 0, this.size);
            this.labels = newLabels;
        }
        this.labels[this.size] = this.labelIndex.indexOf(label, true);
    }

    private void addFeatures(Counter<F> features) {
        if (this.data.length == this.size) {
            int[][] newData = new int[this.size * 2][];
            double[][] newValues = new double[this.size * 2][];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            System.arraycopy(this.values, 0, newValues, 0, this.size);
            this.data = newData;
            this.values = newValues;
        }
        ArrayList<F> featureNames = new ArrayList<F>(features.keySet());
        int nFeatures = featureNames.size();
        this.data[this.size] = new int[nFeatures];
        this.values[this.size] = new double[nFeatures];
        for (int i = 0; i < nFeatures; ++i) {
            Object feature = featureNames.get(i);
            int fID = this.featureIndex.indexOf(feature, true);
            if (fID >= 0) {
                this.data[this.size][i] = fID;
                this.values[this.size][i] = features.getCount(feature);
                continue;
            }
            assert (this.featureIndex.isLocked()) : "Could not add feature to index: " + feature;
        }
    }

    @Override
    public void clear() {
        this.clear(10);
    }

    @Override
    public void clear(int numDatums) {
        this.initialize(numDatums);
    }

    @Override
    protected void initialize(int numDatums) {
        this.labelIndex = new HashIndex();
        this.featureIndex = new HashIndex();
        this.labels = new int[numDatums];
        this.data = new int[numDatums][];
        this.values = new double[numDatums][];
        this.sourcesAndIds = new ArrayList(numDatums);
        this.size = 0;
    }

    @Override
    public void summaryStatistics() {
        System.err.println("numDatums: " + this.size);
        System.err.print("numLabels: " + this.labelIndex.size() + " [");
        Iterator iter = this.labelIndex.iterator();
        while (iter.hasNext()) {
            System.err.print(iter.next());
            if (!iter.hasNext()) continue;
            System.err.print(", ");
        }
        System.err.println("]");
        System.err.println("numFeatures (Phi(X) types): " + this.featureIndex.size());
    }

    public void printFullFeatureMatrix(PrintWriter pw) {
        int i;
        String sep = "\t";
        for (i = 0; i < this.featureIndex.size(); ++i) {
            pw.print(sep + this.featureIndex.get(i));
        }
        pw.println();
        for (i = 0; i < this.labels.length; ++i) {
            int j;
            pw.print(this.labelIndex.get(i));
            Set<Integer> feats = Generics.newHashSet();
            for (j = 0; j < this.data[i].length; ++j) {
                int feature = this.data[i][j];
                feats.add(feature);
            }
            for (j = 0; j < this.featureIndex.size(); ++j) {
                if (feats.contains(j)) {
                    pw.print(sep + "1");
                    continue;
                }
                pw.print(sep + "0");
            }
            pw.println();
        }
    }

    public void printFullFeatureMatrixWithValues(PrintWriter pw) {
        int i;
        String sep = "\t";
        for (i = 0; i < this.featureIndex.size(); ++i) {
            pw.print(sep + this.featureIndex.get(i));
        }
        pw.println();
        for (i = 0; i < this.size; ++i) {
            int j;
            pw.print(this.labelIndex.get(this.labels[i]));
            Map<Integer, Double> feats = Generics.newHashMap();
            for (j = 0; j < this.data[i].length; ++j) {
                int feature = this.data[i][j];
                double val = this.values[i][j];
                feats.put(feature, new Double(val));
            }
            for (j = 0; j < this.featureIndex.size(); ++j) {
                if (feats.containsKey(j)) {
                    pw.print(sep + feats.get(j));
                    continue;
                }
                pw.print(sep + " ");
            }
            pw.println();
        }
        pw.flush();
    }

    public static RVFDataset<String, String> readSVMLightFormat(String filename) {
        return RVFDataset.readSVMLightFormat(filename, new HashIndex<String>(), new HashIndex<String>());
    }

    public static RVFDataset<String, String> readSVMLightFormat(String filename, List<String> lines) {
        return RVFDataset.readSVMLightFormat(filename, new HashIndex<String>(), new HashIndex<String>(), lines);
    }

    public static RVFDataset<String, String> readSVMLightFormat(String filename, Index<String> featureIndex, Index<String> labelIndex) {
        return RVFDataset.readSVMLightFormat(filename, featureIndex, labelIndex, null);
    }

    public void selectFeaturesFromSet(Set<F> featureSet) {
        HashIndex<F> newFeatureIndex = new HashIndex<F>();
        int[] featMap = new int[this.featureIndex.size()];
        Arrays.fill(featMap, -1);
        for (F feature : featureSet) {
            int newID;
            int oldID = this.featureIndex.indexOf(feature);
            if (oldID < 0) continue;
            featMap[oldID] = newID = newFeatureIndex.indexOf(feature, true);
        }
        this.featureIndex = newFeatureIndex;
        for (int i = 0; i < this.size; ++i) {
            int j;
            ArrayList<Integer> featList = new ArrayList<Integer>(this.data[i].length);
            ArrayList<Double> valueList = new ArrayList<Double>(this.values[i].length);
            for (j = 0; j < this.data[i].length; ++j) {
                if (featMap[this.data[i][j]] < 0) continue;
                featList.add(featMap[this.data[i][j]]);
                valueList.add(this.values[i][j]);
            }
            this.data[i] = new int[featList.size()];
            this.values[i] = new double[valueList.size()];
            for (j = 0; j < this.data[i].length; ++j) {
                this.data[i][j] = (Integer)featList.get(j);
                this.values[i][j] = (Double)valueList.get(j);
            }
        }
    }

    @Override
    public void applyFeatureCountThreshold(int k) {
        int i;
        float[] counts = this.getFeatureCounts();
        HashIndex newFeatureIndex = new HashIndex();
        int[] featMap = new int[this.featureIndex.size()];
        for (i = 0; i < featMap.length; ++i) {
            Object feat = this.featureIndex.get(i);
            if (counts[i] >= (float)k) {
                int newIndex = newFeatureIndex.size();
                newFeatureIndex.add(feat);
                featMap[i] = newIndex;
                continue;
            }
            featMap[i] = -1;
        }
        this.featureIndex = newFeatureIndex;
        for (i = 0; i < this.size; ++i) {
            int j;
            ArrayList<Integer> featList = new ArrayList<Integer>(this.data[i].length);
            ArrayList<Double> valueList = new ArrayList<Double>(this.values[i].length);
            for (j = 0; j < this.data[i].length; ++j) {
                if (featMap[this.data[i][j]] < 0) continue;
                featList.add(featMap[this.data[i][j]]);
                valueList.add(this.values[i][j]);
            }
            this.data[i] = new int[featList.size()];
            this.values[i] = new double[valueList.size()];
            for (j = 0; j < this.data[i].length; ++j) {
                this.data[i][j] = (Integer)featList.get(j);
                this.values[i][j] = (Double)valueList.get(j);
            }
        }
    }

    @Override
    public void applyFeatureMaxCountThreshold(int k) {
        int i;
        float[] counts = this.getFeatureCounts();
        HashIndex newFeatureIndex = new HashIndex();
        int[] featMap = new int[this.featureIndex.size()];
        for (i = 0; i < featMap.length; ++i) {
            Object feat = this.featureIndex.get(i);
            if (counts[i] <= (float)k) {
                int newIndex = newFeatureIndex.size();
                newFeatureIndex.add(feat);
                featMap[i] = newIndex;
                continue;
            }
            featMap[i] = -1;
        }
        this.featureIndex = newFeatureIndex;
        for (i = 0; i < this.size; ++i) {
            int j;
            ArrayList<Integer> featList = new ArrayList<Integer>(this.data[i].length);
            ArrayList<Double> valueList = new ArrayList<Double>(this.values[i].length);
            for (j = 0; j < this.data[i].length; ++j) {
                if (featMap[this.data[i][j]] < 0) continue;
                featList.add(featMap[this.data[i][j]]);
                valueList.add(this.values[i][j]);
            }
            this.data[i] = new int[featList.size()];
            this.values[i] = new double[valueList.size()];
            for (j = 0; j < this.data[i].length; ++j) {
                this.data[i][j] = (Integer)featList.get(j);
                this.values[i][j] = (Double)valueList.get(j);
            }
        }
    }

    private static RVFDataset<String, String> readSVMLightFormat(String filename, Index<String> featureIndex, Index<String> labelIndex, List<String> lines) {
        RVFDataset<String, String> dataset;
        BufferedReader in = null;
        try {
            dataset = new RVFDataset<String, String>(10, featureIndex, labelIndex);
            in = IOUtils.readerFromString(filename);
            while (in.ready()) {
                String line = in.readLine();
                if (lines != null) {
                    lines.add(line);
                }
                dataset.add(RVFDataset.svmLightLineToRVFDatum(line));
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeIOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeIgnoringExceptions(in);
                throw throwable;
            }
        }
        IOUtils.closeIgnoringExceptions(in);
        return dataset;
    }

    public static RVFDatum<String, String> svmLightLineToRVFDatum(String l) {
        l = l.replaceFirst("#.*$", "");
        String[] line = l.split("\\s+");
        ClassicCounter<String> features = new ClassicCounter<String>();
        for (int i = 1; i < line.length; ++i) {
            String[] f = line[i].split(":");
            if (f.length != 2) {
                throw new IllegalArgumentException("Bad data format: " + l);
            }
            double val = Double.parseDouble(f[1]);
            features.incrementCount(f[0], val);
        }
        return new RVFDatum<String, String>(features, line[0]);
    }

    public void readSVMLightFormat(File file) {
        for (String line : IOUtils.readLines(file)) {
            line = line.replaceAll("#.*", "");
            String[] items = line.split("\\s+");
            Integer label = Integer.parseInt(items[0]);
            ClassicCounter features = new ClassicCounter();
            for (int i = 1; i < items.length; ++i) {
                String[] featureItems = items[i].split(":");
                int feature = Integer.parseInt(featureItems[0]);
                double value = Double.parseDouble(featureItems[1]);
                features.incrementCount(this.featureIndex.get(feature), value);
            }
            this.add(new RVFDatum(features, this.labelIndex.get(label)));
        }
    }

    public void writeSVMLightFormat(File file) throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(file);
        this.writeSVMLightFormat(writer);
        writer.close();
    }

    public void writeSVMLightFormat(PrintWriter writer) {
        for (RVFDatum<L, F> datum : this) {
            writer.print(this.labelIndex.indexOf(datum.label()));
            Counter<F> features = datum.asFeaturesCounter();
            for (F feature : features.keySet()) {
                double count = features.getCount(feature);
                writer.format(" %s:%f", this.featureIndex.indexOf(feature), count);
            }
            writer.println();
        }
    }

    @Override
    public void printSparseFeatureMatrix() {
        this.printSparseFeatureMatrix(new PrintWriter(System.out, true));
    }

    @Override
    public void printSparseFeatureMatrix(PrintWriter pw) {
        String sep = "\t";
        for (int i = 0; i < this.size; ++i) {
            int[] datum;
            pw.print(this.labelIndex.get(this.labels[i]));
            for (int feat : datum = this.data[i]) {
                pw.print(sep);
                pw.print(this.featureIndex.get(feat));
            }
            pw.println();
        }
    }

    public void printSparseFeatureValues(PrintWriter pw) {
        for (int i = 0; i < this.size; ++i) {
            this.printSparseFeatureValues(i, pw);
        }
    }

    public void printSparseFeatureValues(int datumNo, PrintWriter pw) {
        pw.print(this.labelIndex.get(this.labels[datumNo]));
        pw.print('\t');
        pw.println("LABEL");
        int[] datum = this.data[datumNo];
        double[] vals = this.values[datumNo];
        assert (datum.length == vals.length);
        for (int i = 0; i < datum.length; ++i) {
            pw.print(this.featureIndex.get(datum[i]));
            pw.print('\t');
            pw.println(vals[i]);
        }
        pw.println();
    }

    public static void main(String[] args) {
        RVFDataset data = new RVFDataset();
        ClassicCounter<String> c1 = new ClassicCounter<String>();
        c1.incrementCount("fever", 3.5);
        c1.incrementCount("cough", 1.1);
        c1.incrementCount("congestion", 4.2);
        ClassicCounter<String> c2 = new ClassicCounter<String>();
        c2.incrementCount("fever", 1.5);
        c2.incrementCount("cough", 2.1);
        c2.incrementCount("nausea", 3.2);
        ClassicCounter<String> c3 = new ClassicCounter<String>();
        c3.incrementCount("cough", 2.5);
        c3.incrementCount("congestion", 3.2);
        data.add(new RVFDatum(c1, "cold"));
        data.add(new RVFDatum(c2, "flu"));
        data.add(new RVFDatum(c3, "cold"));
        data.summaryStatistics();
        LinearClassifierFactory factory = new LinearClassifierFactory();
        factory.useQuasiNewton();
        Classifier c = factory.trainClassifier((GeneralDataset)data);
        ClassicCounter<String> c4 = new ClassicCounter<String>();
        c4.incrementCount("cough", 2.3);
        c4.incrementCount("fever", 1.3);
        RVFDatum datum = new RVFDatum(c4);
        ((LinearClassifier)c).justificationOf(datum);
    }

    @Override
    public double[][] getValuesArray() {
        if (this.size == 0) {
            return new double[0][];
        }
        this.values = this.trimToSize(this.values);
        this.data = this.trimToSize(this.data);
        return this.values;
    }

    public String toString() {
        return "Dataset of size " + this.size;
    }

    public String toSummaryString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("Number of data points: " + this.size());
        pw.print("Number of labels: " + this.labelIndex.size() + " [");
        Iterator iter = this.labelIndex.iterator();
        while (iter.hasNext()) {
            pw.print(iter.next());
            if (!iter.hasNext()) continue;
            pw.print(", ");
        }
        pw.println("]");
        pw.println("Number of features (Phi(X) types): " + this.featureIndex.size());
        pw.println("Number of active feature types: " + this.numFeatureTypes());
        pw.println("Number of active feature tokens: " + this.numFeatureTokens());
        return sw.toString();
    }

    @Override
    public Iterator<RVFDatum<L, F>> iterator() {
        return new Iterator<RVFDatum<L, F>>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < RVFDataset.this.size;
            }

            @Override
            public RVFDatum<L, F> next() {
                if (this.index >= RVFDataset.this.size) {
                    throw new NoSuchElementException();
                }
                RVFDatum next = RVFDataset.this.getRVFDatum(this.index);
                ++this.index;
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void randomize(long randomSeed) {
        Random rand = new Random(randomSeed);
        for (int j = this.size - 1; j > 0; --j) {
            int randIndex = rand.nextInt(j);
            int[] tmp = this.data[randIndex];
            this.data[randIndex] = this.data[j];
            this.data[j] = tmp;
            int tmpl = this.labels[randIndex];
            this.labels[randIndex] = this.labels[j];
            this.labels[j] = tmpl;
            double[] tmpv = this.values[randIndex];
            this.values[randIndex] = this.values[j];
            this.values[j] = tmpv;
        }
    }

    @Override
    public <E> void shuffleWithSideInformation(long randomSeed, List<E> sideInformation) {
        if (this.size != sideInformation.size()) {
            throw new IllegalArgumentException("shuffleWithSideInformation: sideInformation not of same size as Dataset");
        }
        Random rand = new Random(randomSeed);
        for (int j = this.size - 1; j > 0; --j) {
            int randIndex = rand.nextInt(j);
            int[] tmp = this.data[randIndex];
            this.data[randIndex] = this.data[j];
            this.data[j] = tmp;
            int tmpl = this.labels[randIndex];
            this.labels[randIndex] = this.labels[j];
            this.labels[j] = tmpl;
            double[] tmpv = this.values[randIndex];
            this.values[randIndex] = this.values[j];
            this.values[j] = tmpv;
            E tmpE = sideInformation.get(randIndex);
            sideInformation.set(randIndex, sideInformation.get(j));
            sideInformation.set(j, tmpE);
        }
    }
}

