/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class Timing {
    private long start;
    private static long startTime = System.currentTimeMillis();
    private static final NumberFormat nf = new DecimalFormat("0.0");

    public Timing() {
        this.start();
    }

    public void start() {
        this.start = System.currentTimeMillis();
    }

    public long report() {
        return System.currentTimeMillis() - this.start;
    }

    public long report(String str, PrintStream stream) {
        long elapsed = this.report();
        stream.println(str + " Time elapsed: " + elapsed + " ms");
        return elapsed;
    }

    public long report(String str) {
        return this.report(str, System.err);
    }

    public long report(String str, PrintWriter writer) {
        long elapsed = this.report();
        writer.println(str + " Time elapsed: " + elapsed + " ms");
        return elapsed;
    }

    public String toSecondsString() {
        return Timing.toSecondsString(this.report());
    }

    public static String toSecondsString(long elapsed) {
        return nf.format((double)elapsed / 1000.0);
    }

    public static String toMilliSecondsString(long elapsed) {
        return nf.format(elapsed);
    }

    public long restart() {
        long elapsed = this.report();
        this.start();
        return elapsed;
    }

    public long restart(String str, PrintStream stream) {
        long elapsed = this.report(str, stream);
        this.start();
        return elapsed;
    }

    public long restart(String str) {
        return this.restart(str, System.err);
    }

    public long restart(String str, PrintWriter writer) {
        long elapsed = this.report(str, writer);
        this.start();
        return elapsed;
    }

    public long stop() {
        long elapsed = this.report();
        this.start = 0L;
        return elapsed;
    }

    public long stop(String str, PrintStream stream) {
        this.report(str, stream);
        return this.stop();
    }

    public long stop(String str) {
        return this.stop(str, System.err);
    }

    public long stop(String str, PrintWriter writer) {
        this.report(str, writer);
        return this.stop();
    }

    public static void startTime() {
        startTime = System.currentTimeMillis();
    }

    public static long endTime() {
        return System.currentTimeMillis() - startTime;
    }

    public static long endTime(String str, PrintStream stream) {
        long elapsed = Timing.endTime();
        stream.println(str + " Time elapsed: " + elapsed + " ms");
        return elapsed;
    }

    public static long endTime(String str) {
        return Timing.endTime(str, System.err);
    }

    public void doing(String str) {
        System.err.print(str);
        System.err.print(" ... ");
        System.err.flush();
        this.start();
    }

    public void done() {
        System.err.println("done [" + this.toSecondsString() + " sec].");
    }

    public void done(String msg) {
        System.err.println(msg + " done [" + this.toSecondsString() + " sec].");
    }

    public static void startDoing(String str) {
        System.err.print(str);
        System.err.print(" ... ");
        System.err.flush();
        Timing.startTime();
    }

    public static void endDoing() {
        long elapsed = System.currentTimeMillis() - startTime;
        System.err.println("done [" + nf.format((double)elapsed / 1000.0) + " sec].");
    }

    public static void endDoing(String msg) {
        long elapsed = System.currentTimeMillis() - startTime;
        System.err.println(msg + " done [" + nf.format((double)elapsed / 1000.0) + " sec].");
    }

    public static long tick() {
        long elapsed = System.currentTimeMillis() - startTime;
        Timing.startTime();
        return elapsed;
    }

    public static long tick(String str, PrintStream stream) {
        long elapsed = Timing.tick();
        stream.println(str + " Time elapsed: " + elapsed + " ms");
        return elapsed;
    }

    public static long tick(String str) {
        return Timing.tick(str, System.err);
    }

    public String toString() {
        return "Timing[start=" + startTime + "]";
    }
}

